(function ($) {
    $(document).ready(function () {

        $('.x_portfolio').each(function () {

            let $this = $(this);
            let module_id = $(this).data('module');

            new Vue({
                el: $this[0],
                data: function () {
                    return {
                        categories: window[module_id]['categories'],
                        total: window[module_id]['total'],
                        active_category: '',
                        category: '',
                        products: {},
                        loading: false,
                        packered: false,
                        offset: 0,
                    }
                },
                mounted: function () {
                    if (this.categories.length) {
                        this.getPortfolio(this.categories[0]);
                    }

                },
                methods: {
                    hasMorePosts: function() {
                        let _this = this;
                        let c = _this.products[_this.active_category];
                        return c.total > (c.offset + 1) * c.per_page;
                    },
                    loadMore: function () {
                        let _this = this;
                        if(_this.loading) return false;
                        _this.loading = true;

                        let c = _this.products[_this.active_category];
                        let offset = c.offset + 1;


                        let url = `${x_ajax_url}?action=x_get_portfolio&term_id=${_this.category.term_id}&offset=${offset}`;

                        _this.$http.get(url).then(function (r) {
                            let products = r.body;
                            _this.$set(_this.products[_this.category.term_id], 'products', c['products'].concat(products['products']));
                            _this.$set(_this.products[_this.category.term_id], 'offset', products['offset']);
                            _this.$set(_this.products[_this.category.term_id], 'per_page', products['per_page']);

                            _this.packery();
                        });
                    },
                    getPortfolio: function (category, newOffset) {
                        let _this = this;
                        _this.$set(_this, 'category', category);
                        _this.$set(_this, 'active_category', category.term_id);
                        _this.loading = true;

                        if (typeof _this.products[category.term_id] !== 'undefined') {
                            _this.packery();
                            return;
                        }

                        _this.$set(_this.products, category.term_id, []);

                        let url = `${x_ajax_url}?action=x_get_portfolio&term_id=${category.term_id}&offset=${this.offset}`;

                        _this.$http.get(url).then(function (r) {
                            let products = r.body;

                            _this.$set(_this.products, category.term_id, products);

                            _this.packery();
                        });
                    },
                    packery: function () {
                        let _this = this;
                        Vue.nextTick(function () {
                            let $container = $('.' + module_id + ' .x_portfolio__grid');

                            $container.imagesLoaded(function () {
                                let $pckry = $container.packery({
                                    // options
                                    itemSelector: '.x_portfolio__grid__single',
                                    gutter: 0,
                                });

                                $pckry.packery('reloadItems');

                                setTimeout(function () {

                                    _this.products[_this.active_category].products.forEach(function(val, key) {
                                        _this.$set(_this.products[_this.active_category].products[key], 'loaded', true);
                                    });

                                    let $pckry = $container.packery({
                                        // options
                                        itemSelector: '.x_portfolio__grid__single',
                                        gutter: 0,
                                    });

                                    $pckry.packery('reloadItems');
                                }, 100);

                                _this.loading = false;

                            });

                        })
                    }
                }
            });

        });
    });
})(jQuery);