<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

<div class="u-columns col2-set row" id="customer_login">

    <div class="u-column1 col-xl-6 col-lg-6 col-md-12 col-sm-12">

        <?php endif; ?>

        <div class="elab_form_card">

            <div class="elab_form_card__title">
                <h2><?php esc_html_e('Login', 'elab'); ?></h2>
                <?php do_action('elab_woo_login_right'); ?>
            </div>

            <form class="woocommerce-form woocommerce-form-login login" method="post">

                <?php do_action('woocommerce_login_form_start'); ?>

                <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                    <label for="username"><?php esc_html_e('Name', 'elab'); ?>&nbsp;<span
                                class="required">*</span></label>
                    <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username"
                           id="username" autocomplete="username"
                           value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                </p>
                <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                    <label for="password"><?php esc_html_e('Password', 'elab'); ?>&nbsp;<span
                                class="required">*</span></label>
                    <input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password"
                           id="password" autocomplete="current-password"/>
                </p>

                <?php do_action('woocommerce_login_form'); ?>

                <div class="form-row form-row-submit">
                    <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
                    <button type="submit" class="btn btn-primary" name="login"
                            value="<?php esc_attr_e('Log in', 'elab'); ?>"><?php esc_html_e('Log in', 'elab'); ?></button>
                    <a class="lost_password"
                       href="<?php echo esc_url(wp_lostpassword_url()); ?>">
                        <?php esc_html_e('Lost your password?', 'elab'); ?>
                    </a>

                </div>

                <?php do_action('woocommerce_login_form_end'); ?>

            </form>
        </div>

        <?php if (get_option('woocommerce_enable_myaccount_registration') === 'yes') : ?>

    </div>

    <div class="u-column2 col-xl-6 col-lg-6 col-md-12 col-sm-12">

        <div class="elab_form_card">

            <h2><?php esc_html_e('Register', 'elab'); ?></h2>

            <form method="post"
                  class="woocommerce-form woocommerce-form-register register" <?php do_action('woocommerce_register_form_tag'); ?> >

                <?php do_action('woocommerce_register_form_start'); ?>

                <?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>

                    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                        <label for="reg_username"><?php esc_html_e('Username', 'elab'); ?>&nbsp;<span
                                    class="required">*</span></label>
                        <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username"
                               id="reg_username" autocomplete="username"
                               value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                    </p>

                <?php endif; ?>

                <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                    <label for="reg_email"><?php esc_html_e('Email address', 'elab'); ?>&nbsp;<span
                                class="required">*</span></label>
                    <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email"
                           id="reg_email" autocomplete="email"
                           value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>"/><?php // @codingStandardsIgnoreLine ?>
                </p>

                <?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>

                    <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                        <label for="reg_password"><?php esc_html_e('Password', 'elab'); ?>&nbsp;<span
                                    class="required">*</span></label>
                        <input type="password" class="woocommerce-Input woocommerce-Input--text input-text"
                               name="password" id="reg_password" autocomplete="new-password"/>
                    </p>

                <?php endif; ?>

                <?php do_action('woocommerce_register_form'); ?>

                <div class="woocommerce-FormRow form-row  form-row-submit">
                    <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
                    <button type="submit" class="btn btn-primary" name="register"
                            value="<?php esc_attr_e('Register', 'elab'); ?>"><?php esc_html_e('Register', 'elab'); ?></button>
                </div>

                <?php do_action('woocommerce_register_form_end'); ?>

            </form>

        </div>
    </div>

</div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
