<?php
/**
 * @var $id
 *
 */

?>

<a href="<?php echo esc_url(get_the_permalink($id)); ?>" class="overlay_link"></a>
<div class="x_builder_product_buttons product">

    <div data-tooltip="<?php esc_attr_e('Add to cart', 'elab') ?>" class="x_builder_product_buttons_buy">
        <?php woocommerce_template_loop_add_to_cart(); ?>
    </div>

    <?php if (defined('YITH_WCWL')):
        $url = YITH_WCWL()->get_wishlist_url();
        ?>
        <div class="yith-wcwl-add-to-wishlist add-to-wishlist-<?php echo esc_attr($id); ?>">

            <div class="yith-wcwl-add-button">

                <a href="#"
                   rel="nofollow"
                   data-product-id="<?php echo esc_attr($id); ?>"
                   class="add_to_wishlist">
                    <i class="lnricons-heart"></i>
                    <?php esc_html_e('Add to Wishlist', 'elab'); ?>
                </a>

            </div>

            <div class="yith-wcwl-wishlistexistsbrowse hide" style="display: none;">
                <a href="<?php echo esc_url($url); ?>" rel="nofollow">
                    <i class="lnricons-heart"></i>
                    <?php esc_html_e('Browse Wishlist', 'elab'); ?>
                </a>
            </div>

        </div>

    <?php endif; ?>

    <?php if (defined('YITH_WOOCOMPARE')): ?>
        <a href="#"
           class="compare button x_compare"
           data-product_id="<?php echo intval($id); ?>"
           rel="nofollow">
            <i class="lnricons-shuffle"></i>
            <?php esc_html_e('Compare', 'elab'); ?>
        </a>
    <?php endif; ?>

    <?php if (class_exists('YITH_WCQV')): ?>
        <a href="#"
           class="quick_view yith-wcqv-button"
           data-product_id="<?php echo intval($id); ?>"
           data-tooltip="<?php esc_attr_e('Quick View', 'elab'); ?>">
            <i class="lnricons-eye"></i>
            <?php esc_html_e('Quick view', 'elab'); ?>
        </a>
    <?php endif; ?>

</div>