/**
 * @var elab_vars
 */

(function ($) {

    $(document).ready(function(){
        likeit();
    });

    function likeit() {

        let $like = $('[data-like]');

        $like.each(function () {
            let post_id = $(this).attr('data-like');
            let name = 'plugin_' + post_id;
            let isClicked = localStorage.getItem(name);
            if (isClicked !== null) {
                $('[data-like]').removeClass('notLiked');
            }
        });

        $like.on('click', function (e) {
            e.preventDefault();
            let post_id = $(this).attr('data-like');
            let name = 'plugin_' + post_id;
            let isClicked = localStorage.getItem(name);

            if (isClicked === null) {
                $(this).removeClass('notLiked');
                localStorage.setItem(name, 'setted');
                $.ajax({
                    url: elab_vars['ajax_url'],
                    dataType: 'json',
                    context: this,
                    data: {
                        action: 'elab_like_portfolio',
                        post_id: post_id,
                        security: window.wp_data.elab_like_portfolio
                    },
                    beforeSend: function () {
                        $(this).addClass('loading');
                    },
                    complete: function (data) {
                        var data = data['responseJSON'];
                        $(this).removeClass('loading');
                        $(this).find('span').text(data);
                    }
                });
            }
        });
    }
})(jQuery);