(($) => {

    let preloaderEnabled = false;

    $(document).ready(() => {
        if(!$('body').hasClass('woocommerce-checkout')){
            initNiceSelect();
        }
        widgetList();
        stm_share_url();
        fullwidth();
        toggler();
        menuChilds();

    });



    $(window).load(() => {

        yithChangePopupBehaviour();

        $("body").on('DOMSubtreeModified', "#colorbox", function () {
            let is_visible = $(this).is(":visible");

            if (is_visible) $('body').addClass('compareOnScreen');
            if (!is_visible) $('body').removeClass('compareOnScreen');

        });

        if($('body').hasClass('elab_enable_preloader')) {
            preloaderEnabled = true;
            window.dispatchEvent(new Event('resize'));
            $('body').removeClass('elab_enable_preloader');
        }

    });

    $(window).resize(function () {
        fullwidth();
    });

    let initNiceSelect = () => {

        let $selector = $('select');

        $selector.removeAttr('class');

        $selector.niceSelect();

        $selector.on('change', function () {
            setTimeout(function () {
                $selector.niceSelect('update');
            }, 100);
        });

    };

    let widgetList = () => {
        let selectors = '.widget.widget_nav_menu ul > .menu-item-has-children, .widget_product_categories .product-categories > .cat-parent';
        let $selectors = $(selectors);

        $selectors.each(function () {
            $(this).append('<span class="widget_toggle"><i class="lnricons-plus"></i></span>');
        });

        $selectors.on('click', '.widget_toggle', function () {
            $(this).closest('li').toggleClass('active').find('ul').toggle();
        });

    };

    let stm_share_url = () => {
        $('.stm_js__shareble a').on('click', function (e) {
            e.preventDefault();
            var url = $(this).data('share');
            var social = $(this).data('social') + '_share';
            window.open(url, social, 'width=580,height=296');
        });
    };

    let fullwidth = () => {
        $('[data-fullwidth]').each(function () {
            let $this = $(this);
            let $container = $('.container');
            let windowW = $(window).width();
            let elW = $container.width();

            $container.each(function() {
               if($(this).is(':visible')) {
                   elW = $(this).width();
                   return false;
               }
            });

            let mgLeft = -(windowW - elW) / 2;

            let data = {
                'width': `${windowW}px`,
                'margin-left': `${mgLeft}px`
            };

            $this.css(data);

        })
    };

    let toggler = () => {
        let selector = $('[data-toggle-selector]');

        selector.on('click', function () {

            let open = $(this).attr('data-toggle-selector');
            let $open = $(open);
            if($open.length) {
                $(this).toggleClass('active');
                $open.toggleClass('active');
            }

        });
    };

    let menuChilds = () => {
        let parent = '.stmt-theme-header_menu';
        let $parent = $(`${parent} > .menu-item-has-children`);
        $parent.each(function() {
            $(this).append('<span class="mobile_trigger"></span>');
        });

        $(parent).on('click', '.mobile_trigger', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $(this).closest('li').find('.sub-menu').toggleClass('active');
        });
    };

    let yithChangePopupBehaviour = () => {

        $('body').unbind('yith_woocompare_open_popup');

        $('body').on( 'yith_woocompare_open_popup', function( e, data ) {
            e.stopPropagation();

            let response = data.response;

            $.colorbox({
                href: response,
                iframe: true,
                width: '90%',
                height: '90%',
                className: 'yith_woocompare_colorbox',
                close: yith_woocompare.close_label,
                onClosed: function(){
                    var widget_list = $('.yith-woocompare-widget ul.products-list'),
                        data = {
                            action: yith_woocompare.actionreload,
                            context: 'frontend'
                        };

                    if( typeof $.fn.block != 'undefined' ) {
                        widget_list.block({message: null, overlayCSS: {background: '#fff url(' + yith_woocompare.loader + ') no-repeat center', backgroundSize: '16px 16px', opacity: 0.6}});
                    }

                    $.ajax({
                        type: 'post',
                        url: yith_woocompare.ajaxurl.toString().replace( '%%endpoint%%', yith_woocompare.actionreload ),
                        data: data,
                        success: function(response){
                            // add the product in the widget
                            if( typeof $.fn.block != 'undefined' ) {
                                widget_list.unblock().html(response);
                            }
                            widget_list.html(response);
                        }
                    });
                }
            });

            $(window).resize(function () {
                $.colorbox.resize({
                    width: '90%',
                    height: '90%'
                });
            });

        });
    }


})(jQuery);