<?php

add_action('woocommerce_share', 'stm_get_shares');

function stm_get_shares()
{

    $link = get_the_permalink();
    $image = elab_get_image_url(get_post_thumbnail_id());


    $socials = array();

    $socials['facebook'] = "https://www.facebook.com/sharer/sharer.php?u={$link}";
    $socials['twitter'] = "https://twitter.com/home?status={$link}";
    $socials['google-plus'] = "https://plus.google.com/share?url={$link}";
    $socials['linkedin'] = "https://www.linkedin.com/shareArticle?mini=true&url={$link}&title=&summary=&source=";
    $socials['pinterest'] = "https://pinterest.com/pin/create/button/?url={$link}&media={$image}&description=";
    ob_start();
    ?>

    <div class="x_share">
        <div class="x_share__title">
            <i class="lnricons-share2"></i>
            <?php esc_html_e('Share', 'stm-configurations'); ?>
        </div>
        <div class="stm_share stm_js__shareble">
            <?php foreach ($socials as $social => $url): ?>
                <a href="#"
                   class="__icon icon_12px stm_share_<?php echo esc_attr($social); ?>"
                   data-share="<?php echo esc_url($url); ?>"
                   data-social="<?php echo esc_attr($social); ?>">
                    <i class="fab fa-<?php echo esc_attr($social); ?>"></i>
                </a>
            <?php endforeach; ?>
        </div>
    </div>

    <?php echo ob_get_clean();
}